# Bouncing ball animation.
import pygame
from random import *

def draw ():
    global dx, dy, x, y
    screen.fill( (200, 200, 200) )  # Erase the prior frame
    for i in range(0,n):
        x[i] = x[i] + dx[i] # Change position
        y[i] = y[i] + dy[i]
        if x[i]<=sizes[i]/2 or x[i]>=width-sizes[i]/2: # Bounce X?
            dx[i] = -dx[i]
        if y[i]<=sizes[i]/2 or y[i]>=height-sizes[i]/2:# Bounce Y?
            dy[i] = -dy[i]
        pygame.draw.circle(screen, colors[i], (x[i], y[i]), int(sizes[i]/2))  # Draw the ball

n = 50
x = []      # Initial x position of the balls
y = []      # Initial y position
dx = []     # Speed in x
dy = []     # Speed in y
colors = []
sizes = []
width = 400
height = 400
for i in range (0,n):
    x = x + [randrange(15,width-15)]
    y = y + [randrange(15,height-15)]
    dx = dx + [randrange (-2, 2)]
    dy = dy + [randrange (-2, 2)]
    sizes = sizes + [randrange (2,30)]
    colors = colors +[(randrange(100, 200),
          randrange(100, 200),
          randrange(100, 200)),]

screen = pygame.display.set_mode((width, height))
clock = pygame.time.Clock()
pygame.init()
FPS = 30
while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()
    draw()
    pygame.display.update()

